
#ifndef SST_SEP_ATP_DATA_H
#define SST_SEP_ATP_DATA_H
#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 12 12:56:19 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SST_SEP_ATP_Data.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
/*Basic data test struct*/
    typedef struct TST_ATP_DataOpTestDataStruct{
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxUint32_t                  TST_DataReadOffset;
    DxByte_t                    TST_DataToWrite[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataToWriteSize;
    DxUint32_t                  TST_DataToWriteOffset;
    DxByte_t                    TST_ModifedData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    SSTHandle_t                 TST_DataHandle;
    SSTHandle_t                 TST_AuthHandle;
    } TST_ATP_DataOpTestDataStruct;


TST_ATP_DataOpTestDataStruct* TST_ATP_DataOpTestData;
TST_ATP_BindingWritingPermissionsStruct* TST_ATP_BindingWritingPermissionsTestData;

/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:
*  SST_TST_ATP_BasicDataOp
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the insertion, deletion, modification, opening, getting data size for a data object with an authenticator.
* And demonstration on the use of transaction with data objects
*  
* Algorithm:
*    1. Create a new session by calling: SST_SessionCreate.
*    2. Open a transaction by calling: SST_TransactionStart.
*    3. Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4. Close the transaction by calling: SST_TransactionEnd. 
*    5. Open the new authenticator by calling: SST_AuthenticationOpen.
*    6. Open a transaction by calling: SST_TransactionStart.
*    7. Insert a new data object by calling: SST_InsertData.
*    8. Close the transaction by calling: SST_TransactionEnd.
*    9. Read and compare the inserted data by calling: SST_ReadData.
*    10. Open a transaction by calling: SST_TransactionStart.
*    11. Modify the data from selected location by calling: SST_ModifyData.
*    12. Close the transaction by calling: SST_TransactionEnd.
*    13. Read and compare the modified data by calling: SST_ReadData.
*    14. Get the data size and compare to known by calling: SST_GetDataSize.
*    15. Open a transaction by calling: SST_TransactionStart.
*    16. Delete the data by calling: SST_DeleteData.
*    17. Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18. Close the transaction by calling: SST_TransactionClose.
*    19. Delete the session by calling: SST_SessionDelete.
********************************************************************************/
DxError_t SEPQA_SST_BasicDataOp ( void );

/*****************************************************************************
* Function Name:
*  SST_TST_ATP_BasicUnAuthnticatedDataOp
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the insertion, deletion, modification, opening, getting data size for a data object using default internal authenticator.
* And demonstration on the use of transaction with data objects
*  
* Algorithm:
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Insert a new data object by calling: SST_InsertData.
*    4.    Close the transaction by calling: SST_TransactionEnd.
*    5.    Read and compare the inserted data by calling: SST_ReadData.
*    6.    Open a transaction by calling: SST_TransactionStart.
*    7.    Modify the data from selected location by calling: SST_ModifyData.
*    8.    Close the transaction by calling: SST_TransactionEnd.
*    9.    Read and compare the modified data by calling: SST_ReadData.
*   10.    Get the data size and compare to known by calling: SST_GetDataSize.
*   11.    Open a transaction by calling: SST_TransactionStart.
*   12.    Delete the data by calling: SST_DeleteData.
*   13.    Close the transaction by calling: SST_TransactionClose.
*   14.    Delete the session by calling: SST_SessionDelete.
*******************************************************************************/
DxError_t SEPQA_SST_BasicUnAuthnticatedDataOp ( void );

/*****************************************************************************
* Function Name:
*  SST_TST_ATP_BindingWritingPermissions
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the bind and unbind authenticator to data object capabilities of the SST
* NOTE: this is a test that has error return values as a correct matter or operation!
*  
* Algorithm:       
*    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
*    2.  Create a new session  session#1 by calling: SST_SessionCreate.
*    3.  Create a new session  session#2 by calling: SST_SessionCreate.
*    4.  Create a new session  session#3 by calling: SST_SessionCreate.
*    5.  Open a transaction by calling: SST_TransactionStart.
*    6.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    7.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyRSACreate. 
*    8.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*    9.  Open the public key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_RSA_PSS_Sign
*            iii. SST_AuthenticationOpen.
*    10. Close the transaction by calling: SST_TransactionClose.
*    11. Open a transaction by calling: SST_TransactionStart.
*    12. Open the AES shared key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    13. Close the transaction by calling: SST_TransactionClose.
*    14. Open a transaction by calling: SST_TransactionStart.
*    15. Insert a new data object by calling: SST_InsertData with the Public key authenticator as master authenticator with session id#1.
*    16. Bind the password authenticator to the data object with read only permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    17. Bind the AES shared key authenticator to the data object with read/write permissions by calling: SST_BindAuthenticatorToElement using session id#1.
*    18. Close all the authenticators (one by one) by calling: SST_AuthenticationClose.
*    19. Close the transaction by calling: SST_TransactionClose.
*    20. Open the password authenticator by calling: SST_AuthenticationOpen. using session id#2
*    21. Open a transaction by calling: SST_TransactionStart.
*    22. Using session id#2 read and compare the data by calling: SST_ReadData. 
*    23. Using session id#2 try to modify the data by calling: SST_ModifyData. (This should fail!)
*    24. Try to bind the AES shared key authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    25. Close the authenticator by calling: SST_AuthenticationClose.
*    26. Using session #3 open the AES shared key authenticator by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_AES (Encrypt the challenge using the AES key)
*            iii. SST_AuthenticationOpen.
*    27. Close the transaction by calling: SST_TransactionClose.
*    28. Open a transaction by calling: SST_TransactionStart.
*    29. Modify the data from selected location by calling: SST_ModifyData.
*    30. Close the transaction by calling: SST_TransactionClose.
*    31. Using session #3 open the password authenticator by calling: SST_AuthenticationOpen.
*    32. Open a transaction by calling: SST_TransactionStart.
*    33. Using session #3 bind the password authenticator to the data by calling: SST_BindAuthenticatorToElement. (This should fail!).
*    34. Using session #3 read and compare the modified data by calling: SST_ReadData.
*    35. Using session #3 get the data size and compare to known by calling: SST_GetDataSize.
*    36. Open the public key authenticator with session id#1 by calling:
*            i.   SST_AuthenticatorChallengeGet 
*            ii.  CRYS_RSA_PSS_Sign
*            iii. SST_AuthenticationOpen.
*    37. Close the transaction by calling: SST_TransactionClose.
*    38. Open a transaction by calling: SST_TransactionStart.
*    39. Unbind the data from all other authenticators by calling: SST_AuthenticatorUnbind
*    40. Using session #1 and the master authenticator delete the data by calling: SST_DeleteData.
*    41. Close all of the authenticators (one at a time) by calling: SST_AuthenticationClose.
*    42. Delete all of the authenticators (one at a time) by calling: SST_AuthenticatorDelete.
*    43. Close the transaction by calling: SST_TransactionClose.
*    44. Delete all of the sessions (one at a time) by calling: SST_SessionDelete.
*******************************************************************************/
DxError_t SEPQA_SST_BindingWritingPermissions ( void );

/*****************************************************************************
* Function Name:
*  SST_TST_ATP_DataReplace
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test data replace operation
*  
* Algorithm:
*    1. Create a new session by calling SST_SessionCreate.
*    2. Open a transaction by calling SST_TransactionStart.
*    3. Insert a new data object by calling SST_InsertData.
*    4. Replace the content of the data by calling SST_DataReplace.
*    5. Verify the data was actually replaced by calling SST_DataRead and comparing the data.
*    6. Delete the data by calling SST_DataDelete.
*    7. Close the transaction by calling SST_TransactionEnd.
*    8. Delete the session by calling SST_SessionDelete.
********************************************************************************/
DxError_t SEPQA_SST_DataReplace ( void );

#ifdef __cplusplus
}


#endif

#endif

